//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T> class stList
{
    private:
//+----------------+
        T info;
        stList <T>  *prev,
                    *start;
        uint        counter;
//+----------------+
    public:
//+----------------+
        stList(void)
            :prev(NULL),
            start(NULL),
            counter(0)
        {}
//+----------------+
        void Store(T arg, const uint index = 0xFFFFFFFF)
        {
            stList <T> *loc,
                        *ptr1 = start,
                        *ptr2 = NULL;

            for (uint c = 0; (ptr1 != NULL) && (c < index); ptr2 = ptr1, ptr1 = (*ptr1).start, c++);

            loc = new stList <T>;
            (*loc).info = arg;
            (*loc).start = (ptr2 != NULL ? (*ptr2).start : ptr1);
            (*loc).prev = (ptr1 != NULL ? (*ptr1).prev : ptr2);
            if (ptr2 != NULL) (*ptr2).start = loc; else start = loc;
            if (ptr1 != NULL) (*ptr1).prev = loc; else prev = loc;

            counter++;
        }
//+----------------+
        bool Restore(T &arg, const uint index = 0xFFFFFFFF)
        {
            if ((prev == NULL) || (start == NULL))
                return false;

            stList <T>  *loc = (index < counter ? start : prev),
                        *ptr = NULL;

            for (uint c = 0; (loc != NULL) && (c < index) && (index < counter); ptr = loc, loc = (*loc).start, c++);
            if (loc == NULL) return false;

            if (index == 0)
            {
                start = (*loc).start;
                if (start != NULL) (*start).prev = NULL;
            } else if (index >= (counter - 1))
            {
                prev = (*loc).prev;
                if (prev != NULL) (*prev).start = NULL;
            }
            else
            {
                (*ptr).start = (*loc).start;
                (*loc).start.prev = ptr;
            }
            arg = (*loc).info;
            delete loc;
            counter--;

            return true;
        }
//+----------------+
        // bool Exclude(const uint index)
        // {
        //     T tmp;

        //     return Restore(tmp, index);
        // }
//+----------------+
        stList <T> *operator[](const uint arg)
        {
            stList <T> *loc = start;
            for (uint c = 0; (loc != NULL) && (c < arg); loc = (*loc).start, c++);
            return loc;
        }
//+----------------+
        void operator=(const T arg)
        {
            info = arg;
        }
//+----------------+
        void Debug(void)
        {
            Print("===== DEBUG =====");
            for (stList <T> *loc = start; loc != NULL; loc = (*loc).start)
                PrintFormat("0x%06X ->> 0x%06X <<- 0x%06X = [%d]", (*loc).start, loc, (*loc).prev, (*loc).info);
            Print("=================");
        }
//+----------------+
};
//+------------------------------------------------------------------+
void OnStart(void)
{
    stList <char> list;

    list.Store(10);
    list.Store(84);
    list.Store(-6);
    list.Debug();
    list[0] = 47;
    list.Debug();
    list[2] = 35;

    list.Debug();

    for (char info; list.Restore(info, 0);)
        Print(info);
};
//+------------------------------------------------------------------+